#version 140
#extension GL_EXT_gpu_shader4 : enable
//infinite candylandMod01.fsh by  nexor
//https://www.shadertoy.com/view/ldfBDS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*1.77  //3.14159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define pi 3.141569
#define pi2 (pi*2.)
#define up vec3(.0,1.,.0)
#define sin1(x) (sin(x)*.5+.5)
#define cos1(x) (cos(x)*.5+.5)
#define saw(x) (abs(fract((x))*4.-2.)-1.)
#define rpt(x,c) (mod(x,c)-.5*c)


mat2 rot2(float a)
{
	float c=cos(a),s=sin(a);
	return mat2(c,-s,s,c);
}

mat3 rot(float a,float x,float y,float z)
{
	float s=sin(a),c=cos(a);
	return mat3(
		x+c*y+c*z,s*z,s*y,
		-s*z,y+c*x+c*z,s*x,
		-s*y,-s*x,z+c*x+c*y);
}

float plane(vec3 p,vec3 n,float d)
{
	return dot(p,n)+d;
}

float sphere(vec3 p,float r)
{
	return length(p)-r;
}

float box(vec3 p,vec3 b)
{
	return length(max(abs(p)-b,vec3(.0)));
}

float box(vec3 p,float b)
{
	return box(p,vec3(b));
}

float cylinder(vec3 p,vec3 c)
{
	return length(p.yz-c.xy)-c.z;
}

vec2 opU(vec2 a,vec2 b)
{
	return mix(b,a,step(a.x,b.x));
}

vec2 map(vec3 p)
{
	float m=-1.;
	vec3 q=p;
	vec2 res=vec2(-1.);
	p.y-=-abs(sin(p.z*3.+iTime*.25))*.5
	+sin(iTime*2.+p.x*1.5+p.z*.2)*.1
	;
	res=vec2(100.,m++);
	res=opU(res,vec2(plane(p,up,1.),m++));
	q-=vec3(.0,3.,-20.);
    
	q.xz*=rot2(pi/4.);
	q.z=rpt(q.z,5.);
    q.y-=sin(q.x)*.5;
    q.x-=iTime*.2;
	p=q;
	q.z-=cos(q.x*3.)*.3;
	q.y-=sin(q.x*3.)*.3;
	res=opU(res,vec2(
		cylinder(q,vec3(.2)),m++));
	q=p;
	q.x-=1.5;
	q.z-=cos(q.x*3.)*.3;
	q.y-=sin(q.x*3.)*.3;
	res=opU(res,vec2(
		cylinder(q,vec3(.2)),m++));
	q=p;
	q.x-=1.;
	q.z-=cos(q.x*3.)*.3;
	q.y-=sin(q.x*3.)*.3;
	res=opU(res,vec2(
		cylinder(q,vec3(.2)),m++));
	q=p;
	q.x-=.5;
	q.z-=cos(q.x*3.)*.3;
	q.y-=sin(q.x*3.)*.3;
	res=opU(res,vec2(
		cylinder(q,vec3(.2)),m++));
	return res;
}

vec3 norm(vec3 p)
{
	vec2 e=vec2(1.,-1.)*.5773*.00125;
	return normalize(
		e.xyy*map(p+e.xyy).x+
		e.yxy*map(p+e.yxy).x+
		e.yyx*map(p+e.yyx).x+
		e.xxx*map(p+e.xxx).x);
}

float softshadow( in vec3 ro, in vec3 rd, float mint, float maxt, float k )
{
	rd=normalize(rd);
	float res = 1.0;
	for( float t=mint; t < maxt; )
	{
		float h = map(ro + rd*t).x;
		if( h<0.00025 ) return 0.0;
		res = min( res, k*h/t );
		t += h*.5;
	}
	return res;
}

mat3 material(float m)
{
	mat3 colm=mat3(.0);
	colm[0]=vec3(1.,cos1(m*pi/6.),.0);
	colm[1]=vec3(.5*cos1(m*pi/4.),sin1(m*pi/2.),sin1(m*pi/2.+pi/4.));
	colm[2]=vec3(1.);
	return colm;
}

vec3 shade(vec3 lig,vec3 p,vec3 rd,vec3 nor,float tmin,float tmax,float spec,float k)
{
	float a=1.;
	float d=max(dot(nor,-lig),.0);
	float s=pow(max(dot(rd,reflect(-lig,nor)),.0),spec);
	return vec3(a,d,s)*softshadow(p,-lig,tmin,tmax,k);
}

vec3 color(float m,vec3 ro,vec3 rd,float t,float tmin,float tmax)
{
	vec3 col=vec3(.0);
	vec3 p=ro+t*rd;
	vec3 nor=norm(p);
	mat3 mtr=material(m);
	vec3 lig1=normalize(vec3(6.,-5.,-6.));
	vec3 lig2=normalize(vec3(-8.,-7.,3.5));
	col+=mtr*
		(shade(lig1,p,rd,nor,tmin,tmax,60.,5.)
		+shade(lig2,p,rd,nor,tmin,tmax,90.,2.)
		)*vec3(.3,.3,1.);
	return col;
}

vec3 render(vec3 ro, vec3 rd)
{
	vec3 col=vec3(.5);

	float tmin=.0;
	float tmax=90.;

	float t=tmin;
	float m=-1.;
	for(float i=0.;i<25.;i++)
	{
		float precis=.00125*t;
		vec2 res=map(ro+t*rd);
		if(res.x<precis||t>tmax)break;
		t+=res.x*.5;
		m=res.y;
	}
	m=mix(-1.,m,step(t,tmax));
	col=color(m,ro,rd,t,tmin,tmax);
	col=mix(vec3(.8,.9,1.),col,exp(-t*t*.0007));
	return col;
}

mat3 camera(vec3 ro, vec3 ta, float cr)
{
	vec3 cw = normalize(ta-ro);
	vec3 cp = vec3(sin(cr),cos(cr),.0);
	vec3 cu = normalize(cross(cw,cp));
	vec3 cv = normalize(cross(cu,cw));
	return mat3(cu,cv,cw);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy/iResolution.xy;
	vec3 col = vec3(.0);
	vec2 p=(-iResolution.xy+2.*gl_FragCoord.xy)/iResolution.y;
	vec2 q=iMouse.xy/iResolution.xy;
	q=-1.+2.*q;
	q*=2.;
    q.x+=5.;
	vec3 ro =vec3(.0,9.,-3.);
	vec3 to = vec3(-6.*sin(q.x),7.,-6.*cos(q.x));
	mat3 ca = camera(ro,to,.0);
	vec3 rd = ca*normalize(vec3(p,3.));

	col=render(ro,rd);
    col=pow(col,vec3(1./2.2));

	gl_FragColor = vec4( col, 1.0 );
}